// config: norepeat

#include "GetObjects.js"
#include "GetObject.js"
#include "GetLine.js"

function DoSweep()
{
	var objectpicker = moi.ui.createObjectPicker();
	objectpicker.allowCurves();

	// Get the profiles.
	if ( !GetObjects( objectpicker ) )
		return;
		
	var profiles = objectpicker.objects;
		
	// Get the rails.
	
	moi.ui.beginUIUpdate();
	moi.ui.hideUI( 'ProfileSelectionPrompt' );
	moi.ui.showUI( 'RailSelectionPrompt' );
	moi.ui.endUIUpdate();

	if ( !GetObjects( objectpicker ) )
		return;
	
	var rails = objectpicker.objects;
	
	var factory = moi.command.createFactory( 'sweep' );
		
	factory.setInput( 0, profiles );
	factory.setInput( 1, rails );

	moi.ui.beginUIUpdate();
	moi.ui.hideUI( 'RailSelectionPrompt' );
	moi.ui.showUI( 'SweepParametersPrompt' );
	moi.ui.showUI( 'SweepOptions' );
	
	if ( rails.length != 2 )
	{
		if ( rails.item(0).isClosed )
			moi.ui.hideUI( 'EndPointOptions' );
			
		moi.ui.hideUI( 'maintainheight' );
		moi.ui.hideUI( 'maintaintangent' );
		
		moi.ui.commandUI.g_Is1rail = true;
	}
	else
	{
		moi.ui.hideUI( 'TwistOptions' );
		moi.ui.hideUI( 'EndPointOptions' );
		moi.ui.hideUI( 'setflatdir_tr' );
		
		moi.ui.commandUI.g_Is1rail = false;
	}
		
	if ( !factory.showCapEnds )
		moi.ui.hideUI( 'capends' );
	
	moi.ui.endUIUpdate();

	factory.disableUpdate( true );

	if ( rails.length != 2 )
	{	
		moi.ui.bindUIToInput( 'endpointselect', 'value', factory.getInput(4) );
		moi.ui.bindUIToInput( 'twistselect', 'value', factory.getInput(5) );
	}
	else
	{
		moi.ui.bindUIToInput( 'maintaintangent', 'value', factory.getInput(8) );
	}

	moi.ui.bindUIToInput( 'maintainheight', 'value', factory.getInput(6) );
	moi.ui.bindUIToInput( 'capends', 'value', factory.getInput(7) );
	moi.ui.bindUIToInput( 'profiles', 'value', factory.getInput(10) );
	moi.ui.bindUIToInput( 'profilesnumpoints', 'value', factory.getInput(11) );
	
	factory.disableUpdate( false );
	factory.update();
	
	var commandDialog = moi.ui.commandDialog;
	
	while ( 1 )
	{
		if ( !commandDialog.waitForEvent() )
			return;
			
		var event = commandDialog.event;
			
		if ( event == 'done' )
			break;
			
		if ( event == 'pickscalingrail' )
		{
			moi.ui.beginUIUpdate();
			moi.ui.hideUI( 'SweepParametersPrompt' );
			moi.ui.hideUI( 'SweepOptions' );
			moi.ui.showUI( 'SweepScalingRailPrompt' );
			moi.ui.endUIUpdate();
		
			var crvpicker = moi.ui.createObjectPicker();
			crvpicker.allowCurves();
			crvpicker.allowNestedCancel();

			var gotscalingrail = GetObject( crvpicker );
			
			if ( gotscalingrail )
			{
				var scalingrail = crvpicker.objects.item(0);
				
				factory.setInput( 9, scalingrail );
				factory.update();
			}

			moi.ui.beginUIUpdate();
			moi.ui.hideUI( 'SweepScalingRailPrompt' );
			moi.ui.showUI( 'SweepOptions' );
			moi.ui.showUI( 'SweepParametersPrompt' );
			
			// Once a scaling rail curve has been defined, one rail sweep can also use
			// the maintain height parameter, so show the control for it.
			if ( gotscalingrail && rails.length != 2 )
				moi.ui.showUI( 'maintainheight' );
			
			moi.ui.endUIUpdate();
		}
		else if ( event == 'setflatdir' )
		{
			moi.ui.beginUIUpdate();
			moi.ui.hideUI( 'SweepParametersPrompt' );
			moi.ui.hideUI( 'SweepOptions' );
			moi.ui.showUI( 'FlatDirectionStartPrompt' );
			moi.ui.endUIUpdate();

			factory.disableUpdate( true );
			var linepoints = new Array();
			var gotline = GetLine( linepoints, 'FlatDirectionStartPrompt', 'FlatDirectionEndPrompt' );
			factory.disableUpdate( false );
			
			if ( gotline )
			{
				var dir = moi.vectorMath.makeVector( linepoints[0], linepoints[1] );
				factory.setInput( 12, dir );
				factory.update();
			}
			
			moi.ui.clearPickedPoints();

			moi.ui.beginUIUpdate();
			moi.ui.hideUI( 'FlatDirectionStartPrompt' );
			moi.ui.hideUI( 'FlatDirectionEndPrompt' );
			moi.ui.showUI( 'SweepOptions' );
			moi.ui.showUI( 'SweepParametersPrompt' );
			moi.ui.endUIUpdate();
		}
	}

	factory.commit();
}

DoSweep();
